create or replace package tbicds.PCK_PAT_TREATMENT
AUTHID CURRENT_USER 
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
 --type defs to return recordsets
  type RetRefCursor is ref cursor;
  type refCursor is ref cursor;

/*delete a treatment program*/
procedure DeleteTreatmentProgram( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nProgramID          in number,
                          
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          );
                          
/*delete a treatment*/
procedure DeleteTreatment( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nTreatmentID         in number,
                          
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          );
                          
/*get treatment program rs by program id*/
procedure GetTreatmentProgramRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nTreatmentID           in long,
      pi_nProgramID             in long,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*update patient treatment program record*/
procedure UpdateTreatmentProgram( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nTreatmentID         in number,
                           pi_nProgramID           in number,
                           
                           pi_nCPAID               in number, 
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                                
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          );
                          
/*update patient treatment record*/
procedure UpdateTreatment( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nTreatmentID         in number,
                           
                           pi_nTreatmentType       in number, 
                           pi_vTreatmentTitle      in varchar2,
                           
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                                
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          );
/*get treatment rs by id*/
procedure GetTreatmentRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nTreatmentID           in long,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*get treatment program rs*/
procedure GetTreatmentProgramRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nTreatmentID           in long,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );

/*
gets a recordset of all treatments for this patient
*/
procedure GetTreatmentRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
        
  
/*
insert a new patient treatment
*/
procedure InsertTreatment( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           pi_vPatientID           in varchar2,
                          
                           pi_nTreatmentTypeID     in number,
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                           pi_vTreatmentTitle      in varchar2,
                                
                           po_nPatTreatmentID     out number,
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          );
                          

/*
insert a new patient treatment program
*/
procedure InsertTreatmentProgram( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           
                           pi_vPatientID           in varchar2,
                           pi_nPatTreatmentID      in number,
                           pi_nCPAID               in number,
                                                      
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                          
                           po_nPatTreatProgID     out number,
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          );


end PCK_PAT_TREATMENT;
/

